### Bug description

Clearly and concisely describe the problem or feature (this cannot be empty).

### Root cause

Briefly describe the root cause and analysis of the problem.
If there is an internal discussion on the forum, provide the link.

### Reason for not identifying earlier

Find how it was missed in our earlier testing and development by analysing the below checklist. This will help prevent similar mistakes in the future. 

 - [ ] Guidelines/documents are not followed

    - Common guidelines / Core team guideline
    - Specification document
    - Requirement document

 - [ ] Guidelines/documents are not given


    - Common guidelines / Core team guideline
    - Specification document
    - Requirement document


### Reason:
Mention any one or more reasons from the above points.

### Action taken:

What action did you take to avoid this in future?

### Related areas:

Is there any other related areas also to be addressed?


### Is it a breaking issue?

If it is a breaking issue, provide the commit detail which caused this break.

### Solution description

Describe your code changes in detail for reviewers.

### Output screenshots

Post the output screenshots if an UI is affected or added due to this bug.

### Areas affected and ensured

List the areas affected by your code changes.

### Additional checklist

  - Did you run the automation against your fix?
  - Is there any API name change?
  - Is there any existing behavior change of other features due to this code change?
  - Does your new code introduce new warnings or binding errors?
  - Does your code pass all FxCop and StyleCop rules?
  - Did you record this case in the unit test or UI test?