# ej2-splitbuttons

A package of Syncfusion JavaScript UI Components (Essential JS 2) DropDownButton, SplitButton, ProgressButton and ButtonGroup.

![SplitButton](https://ej2.syncfusion.com/products/images/splitbutton/readme.gif)

> This is a commercial product and requires a paid license for possession or use. Syncfusion’s licensed software, including this component, is subject to the terms and conditions of Syncfusion's EULA (https://www.syncfusion.com/eula/es/). To acquire a license, you can purchase one at https://www.syncfusion.com/sales/products or start a free 30-day trial here (https://www.syncfusion.com/account/manage-trials/start-trials).

> A free community license (https://www.syncfusion.com/products/communitylicense) is also available for companies and individuals whose organizations have less than $1 million USD in annual gross revenue and five or fewer developers.

## Setup

To install `SplitButtons` and its dependent packages, use the following command

```sh
npm install @syncfusion/ej2-splitbuttons
```

## Components included

Following list of components are available in the package.

* DropDownButton - `DropDownButton` is used to toggle contextual overlays for displaying list of action items.
    * [Getting Started](https://ej2.syncfusion.com/documentation/drop-down-button/getting-started?lang=typescript&utm_source=npm&utm_campaign=drop-down-button)
    * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=drop-down-button#/material/button/drop-down-button.html)
    * [Product Page](https://www.syncfusion.com/javascript-ui-controls/dropdown-menu)

* SplitButton - `SplitButton` has primary and secondary button. Primary button is used to select default action and secondary button is used to toggle contextual overlays for displaying list of action items.
    * [Getting Started](https://ej2.syncfusion.com/documentation/split-button/getting-started?lang=typescript&utm_source=npm&utm_campaign=split-button)
    * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=split-button#/material/button/split-button.html)
    * [Product Page](https://www.syncfusion.com/javascript-ui-controls/split-button)

* ProgressButton - `ProgressButton` visualizes the progression of an operation to indicate the user that a process is happening in the background with visual representation.
    * [Getting Started](https://ej2.syncfusion.com/documentation/progress-button/getting-started?lang=typescript&utm_source=npm&utm_campaign=progress-button)
    * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=progress-button#/material/button/progress-button.html)
    * [Product Page](https://www.syncfusion.com/javascript-ui-controls/progress-button)

* ButtonGroup - `ButtonGroup` is a graphical user interface that groups series of buttons horizontally or vertically.
    * [Getting Started](https://ej2.syncfusion.com/documentation/button-group/getting-started?lang=typescript&utm_source=npm&utm_campaign=button-group)
    * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=button-group#/material/button/button-group.html)
    * [Product Page](https://www.syncfusion.com/javascript-ui-controls/button-group)

## Supported Frameworks

These components are available in following list of frameworks.

1. [Angular](https://github.com/syncfusion/ej2-angular-ui-components/tree/master/components/splitbuttons?utm_source=npm&utm_campaign=split-button)
2. [React](https://github.com/syncfusion/ej2-react-ui-components/tree/master/components/splitbuttons?utm_source=npm&utm_campaign=split-button)
3. [VueJS](https://github.com/syncfusion/ej2-vue-ui-components/tree/master/components/splitbuttons?utm_source=npm&utm_campaign=split-button)
4. [ASP.NET Core](https://www.syncfusion.com/aspnet-core-ui-controls)
5. [ASP.NET MVC](https://www.syncfusion.com/aspnet-mvc-ui-controls)
6. [JavaScript (ES5)](https://www.syncfusion.com/javascript-ui-controls)

## Key Features

### DropDownButton

* [**Icons and Navigations**](https://ej2.syncfusion.com/documentation/drop-down-button/popup-items#icons) - Supports text and icon on the DropDownButton and Popup items. URL can be given to Popup items  that creates the anchor link to navigate to the URL provided.

* [**Separator**](https://ej2.syncfusion.com/documentation/drop-down-button/popup-items#separator) - Supports Popup items grouping by using the Separator.

* [**Accessibility**](https://ej2.syncfusion.com/documentation/drop-down-button/accessibility#accessibility) - Provided with built-in accessibility support that helps to access all the DropDownButton component features through the keyboard, screen readers, or other assistive technology devices.

### SplitButton

* [**Icons and Navigations**](https://ej2.syncfusion.com/documentation/split-button/icons-and-separator#splitbutton-icons) - Supports text and icon on the SplitButton and Popup items. URL can be given to Popup items  that creates the anchor link to navigate to the URL provided.

* [**Separator**](https://ej2.syncfusion.com/documentation/split-button/icons-and-separator#separator) - Supports Popup items grouping by using the Separator.

* [**Accessibility**](https://ej2.syncfusion.com/documentation/split-button/accessibility#accessibility) - Provided with built-in accessibility support that helps to access all the SplitButton component features through the keyboard, screen readers, or other assistive technology devices.

### ProgressButton

* **Types, Sizes, and Styles** - Provided with different types, sizes and predefined styles of progress button.

* [**Icons and Spinner**](https://ej2.syncfusion.com/documentation/progress-button/spinner-and-progress#spinner) - Supports icon, spinner and its positioning.

* [**Animation**](https://ej2.syncfusion.com/documentation/progress-button/spinner-and-progress#content-animation) - Provided with predefined animation and progress indicator.

* [**Events**](https://ej2.syncfusion.com/documentation/progress-button/spinner-and-progress#change-progress-dynamically) - Supports event triggering at specified interval.

* [**Accessibility**](https://ej2.syncfusion.com/documentation/progress-button/accessibility#accessibility) - Provided with built-in accessibility support that helps to access all the ProgressButton component features through the keyboard, screen readers, or other assistive technology devices.

### ButtonGroup

* [**Types, Sizes, and Styles**](https://ej2.syncfusion.com/documentation/button-group/types-and-styles#buttongroup-types) - Provided with different types, sizes and predefined styles of button.

* [**Selection**](https://ej2.syncfusion.com/documentation/button-group/selection#selection) - Supports single and multiple selection behaviors.

* [**Orientation**](https://ej2.syncfusion.com/documentation/button-group/getting-started#orientation) - Supports horizontal and vertical orientations.

* [**Nesting**](https://ej2.syncfusion.com/documentation/button-group/selection#nesting) - Supports nesting with drop-down and split button components.

* [**Accessibility**](https://ej2.syncfusion.com/documentation/button-group/accessibility#accessibility) - Built-in accessibility features to access all the button group using the keyboard, screen readers, or other assistive technology devices.

## Support

Product support is available for through following mediums.

* Creating incident in Syncfusion [Direct-trac](https://www.syncfusion.com/support/directtrac/incidents?utm_source=npm&utm_campaign=split-button) support system or [Community forum](https://www.syncfusion.com/forums/essential-js2?utm_source=npm&utm_campaign=split-button).
* New [GitHub issue](https://github.com/syncfusion/ej2-javascript-ui-controls/issues/new).
* Ask your query in [Stack Overflow](https://stackoverflow.com/?utm_source=npm&utm_campaign=split-button) with tag `syncfusion`, `ej2`.

## License

Check the license detail [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/license?utm_source=npm&utm_campaign=split-button).

## Changelog

Check the changelog [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/controls/splitbuttons/CHANGELOG.md?utm_source=npm&utm_campaign=split-button)

© Copyright 2023 Syncfusion, Inc. All Rights Reserved. The Syncfusion Essential Studio license and copyright applies to this distribution.