# ej2-lists

The listview control allows you to select an item or multiple items from a list-like interface and represents the data in interactive hierarchical structure across different layouts or views. Lists are used for displaying data, data navigation, and data entry.

![ej2-lists](https://ej2.syncfusion.com/products/images/listview/readme.gif)

> This is a commercial product and requires a paid license for possession or use. Syncfusion’s licensed software, including this control, is subject to the terms and conditions of Syncfusion's [EULA](https://www.syncfusion.com/eula/es/?utm_source=npm&utm_campaign=listview). To acquire a license, you can purchase one at [https://www.syncfusion.com/sales/products](https://www.syncfusion.com/sales/products/?utm_source=npm&utm_campaign=listview) or start a free 30-day trial [here](https://www.syncfusion.com/account/manage-trials/start-trials/?utm_source=npm&utm_campaign=listview).

> A free [community license](https://www.syncfusion.com/products/communitylicense/?utm_source=npm&utm_campaign=listview) is also available for companies and individuals whose organizations have less than $1 million USD in annual gross revenue and five or fewer developers.

## Setup

To install `Lists` and its dependent packages, use the following command.

```sh
npm install @syncfusion/ej2-lists
```

## Resources

* [Getting Started](https://ej2.syncfusion.com/documentation/listview/getting-started/?utm_source=npm&utm_campaign=listview)
* [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/default.html)
* [Product Page](https://www.syncfusion.com/javascript-ui-controls/listview/?utm_source=npm&utm_campaign=listview)

## Supported Frameworks

`Lists` control is also offered in following list of frameworks.

1. [Angular](https://github.com/syncfusion/ej2-angular-ui-components/tree/master/components/lists/?utm_source=npm&utm_campaign=listview)
2. [React](https://github.com/syncfusion/ej2-react-ui-components/tree/master/components/lists/?utm_source=npm&utm_campaign=listview)
3. [VueJS](https://github.com/syncfusion/ej2-vue-ui-components/tree/master/components/lists/?utm_source=npm&utm_campaign=listview)
4. [ASP.NET Core](https://www.syncfusion.com/aspnet-core-ui-controls/listview/?utm_source=npm&utm_campaign=listview)
5. [ASP.NET MVC](https://www.syncfusion.com/aspnet-mvc-ui-controls/listview/?utm_source=npm&utm_campaign=listview)
6. [JavaScript (ES5)](https://www.syncfusion.com/javascript-ui-controls/listview/?utm_source=npm&utm_campaign=listview)

## Showcase samples

* Webmail ([Live Demo](https://ej2.syncfusion.com/showcase/typescript/webmail/?utm_source=npm&utm_campaign=listview))
* Call History ([Live Demo](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/call-history.html))

## Key Features

* [**Data binding**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/default.html) - Supports data binding to display the list of items from the local or server-side data source.

* [**Grouping**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/default.html) - Provides support to group the logically related items under a category.

* [**Nested list**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/nested-list.html) - Displays a set of nested list items in different layout.

* [**Virtualization**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/virtualization.html) - Allows you to load only viewable list items in a view port which will increase ListView performance on loading large number of data.

* [**Check list**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/checklist.html) - Displays list item with checkbox which allows you to select single or select multiple items.

* [**Customizing templates**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/group-template.html) - Allows you to customize the list item, header, and category group header.

* [**Accessibility**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=listview#/material/listview/default.html) - Provides built-in accessibility support that helps to access all the ListView control features through the keyboard, on-screen readers, or other assistive technology devices.

## Support

Product support is available for through following mediums.

* Creating incident in Syncfusion [Direct-Trac](https://www.syncfusion.com/support/directtrac/incidents/?utm_source=npm&utm_campaign=listview) support system or [Community forum](https://www.syncfusion.com/forums/essential-js2/?utm_source=npm&utm_campaign=listview).
* New [GitHub issue](https://github.com/syncfusion/ej2-javascript-ui-controls/issues/new/?utm_source=npm&utm_campaign=listview).
* Ask your query in [Stack Overflow](https://stackoverflow.com/?utm_source=npm&utm_campaign=listview/?utm_source=npm&utm_campaign=listview) with tag `syncfusion` and `ej2`.

## License

Check the license detail [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/license/?utm_source=npm&utm_campaign=listview).

## Changelog

Check the changelog [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/controls/lists/CHANGELOG.md/?utm_source=npm&utm_campaign=listview)

© Copyright 2023 Syncfusion, Inc. All Rights Reserved. The Syncfusion Essential Studio license and copyright applies to this distribution.
