var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
// eslint-disable-next-line @typescript-eslint/triple-slash-reference
/// <reference path='../combo-box/combo-box-model.d.ts'/>
import { Property, EventHandler, isNullOrUndefined, detach } from '@syncfusion/ej2-base';
import { Event, Complex } from '@syncfusion/ej2-base';
import { removeClass, NotifyPropertyChanges } from '@syncfusion/ej2-base';
import { dropDownListClasses } from '../drop-down-list/drop-down-list';
import { ComboBox } from '../combo-box/combo-box';
import { highlightSearch, revertHighlightSearch } from '../common/highlight-search';
import { Search } from '../common/incremental-search';
import { FieldSettings } from '../drop-down-base/drop-down-base';
import { Input } from '@syncfusion/ej2-inputs';
import { DataManager, Predicate, Query } from '@syncfusion/ej2-data';
dropDownListClasses.root = 'e-autocomplete';
dropDownListClasses.icon = 'e-input-group-icon e-ddl-icon e-search-icon';
/**
 * The AutoComplete component provides the matched suggestion list when type into the input,
 * from which the user can select one.
 * ```html
 * <input id="list" type="text"/>
 * ```
 * ```typescript
 *   let atcObj:AutoComplete = new AutoComplete();
 *   atcObj.appendTo("#list");
 * ```
 */
var AutoComplete = /** @class */ (function (_super) {
    __extends(AutoComplete, _super);
    /**
     * * Constructor for creating the widget
     *
     * @param {AutoCompleteModel} options - Specifies the AutoComplete model.
     * @param {string | HTMLElement} element - Specifies the element to render as component.
     * @private
     */
    function AutoComplete(options, element) {
        var _this_1 = _super.call(this, options, element) || this;
        _this_1.isFiltered = false;
        _this_1.searchList = false;
        return _this_1;
    }
    /**
     * Initialize the event handler
     *
     * @private
     * @returns {void}
     */
    AutoComplete.prototype.preRender = function () {
        _super.prototype.preRender.call(this);
    };
    AutoComplete.prototype.getLocaleName = function () {
        return 'auto-complete';
    };
    AutoComplete.prototype.getNgDirective = function () {
        return 'EJS-AUTOCOMPLETE';
    };
    AutoComplete.prototype.getQuery = function (query) {
        var filterQuery = query ? query.clone() : this.query ? this.query.clone() : new Query();
        var filterType = (this.queryString === '' && !isNullOrUndefined(this.value)) ? 'equal' : this.filterType;
        var queryString = (this.queryString === '' && !isNullOrUndefined(this.value)) ? this.value : this.queryString;
        if (this.isFiltered) {
            return filterQuery;
        }
        if (this.queryString !== null && this.queryString !== '') {
            var dataType = this.typeOfData(this.dataSource).typeof;
            if (!(this.dataSource instanceof DataManager) && dataType === 'string' || dataType === 'number') {
                filterQuery.where('', filterType, queryString, this.ignoreCase, this.ignoreAccent);
            }
            else {
                var mapping = !isNullOrUndefined(this.fields.value) ? this.fields.value : '';
                filterQuery.where(mapping, filterType, queryString, this.ignoreCase, this.ignoreAccent);
            }
        }
        if (!isNullOrUndefined(this.suggestionCount)) {
            // Since defualt value of suggestioncount is 20, checked the condition
            if (this.suggestionCount !== 20) {
                for (var queryElements = 0; queryElements < filterQuery.queries.length; queryElements++) {
                    if (filterQuery.queries[queryElements].fn === 'onTake') {
                        filterQuery.queries.splice(queryElements, 1);
                    }
                }
            }
            filterQuery.take(this.suggestionCount);
        }
        return filterQuery;
    };
    AutoComplete.prototype.searchLists = function (e) {
        var _this_1 = this;
        this.isTyped = true;
        this.isDataFetched = this.isSelectCustom = false;
        if (isNullOrUndefined(this.list)) {
            _super.prototype.renderList.call(this, e, true);
        }
        this.queryString = this.filterInput.value;
        if (e.type !== 'mousedown' && (e.keyCode === 40 || e.keyCode === 38)) {
            this.queryString = this.queryString === '' ? null : this.queryString;
            this.beforePopupOpen = true;
            this.resetList(this.dataSource, this.fields, null, e);
            return;
        }
        this.isSelected = false;
        this.activeIndex = null;
        var eventArgs = {
            preventDefaultAction: false,
            text: this.filterInput.value,
            updateData: function (dataSource, query, fields) {
                if (eventArgs.cancel) {
                    return;
                }
                _this_1.isFiltered = true;
                _this_1.filterAction(dataSource, query, fields);
            },
            cancel: false
        };
        this.trigger('filtering', eventArgs, function (eventArgs) {
            if (!eventArgs.cancel && !_this_1.isFiltered && !eventArgs.preventDefaultAction) {
                _this_1.searchList = true;
                _this_1.filterAction(_this_1.dataSource, null, _this_1.fields, e);
            }
        });
    };
    /**
     * To filter the data from given data source by using query
     *
     * @param {Object[] | DataManager } dataSource - Set the data source to filter.
     * @param {Query} query - Specify the query to filter the data.
     * @param {FieldSettingsModel} fields - Specify the fields to map the column in the data table.
     * @returns {void}

     */
    AutoComplete.prototype.filter = function (dataSource, query, fields) {
        this.isFiltered = true;
        this.filterAction(dataSource, query, fields);
    };
    AutoComplete.prototype.filterAction = function (dataSource, query, fields, e) {
        this.beforePopupOpen = true;
        if (this.queryString !== '' && (this.queryString.length >= this.minLength)) {
            this.resetList(dataSource, fields, query, e);
        }
        else {
            this.hidePopup(e);
            this.beforePopupOpen = false;
        }
        this.renderReactTemplates();
    };
    AutoComplete.prototype.clearAll = function (e, property) {
        if (isNullOrUndefined(property) || (!isNullOrUndefined(property) && isNullOrUndefined(property.dataSource))) {
            _super.prototype.clearAll.call(this, e);
        }
        if (this.beforePopupOpen) {
            this.hidePopup();
        }
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    AutoComplete.prototype.onActionComplete = function (ulElement, list, e, isUpdated) {
        this.fixedHeaderElement = null;
        _super.prototype.onActionComplete.call(this, ulElement, list, e);
        var item = this.list.querySelector('.' + dropDownListClasses.li);
        if (!isNullOrUndefined(item)) {
            removeClass([item], dropDownListClasses.focus);
        }
        this.postBackAction();
    };
    AutoComplete.prototype.postBackAction = function () {
        if (this.autofill && !isNullOrUndefined(this.liCollections[0]) && this.searchList) {
            var items = [this.liCollections[0]];
            var dataSource = this.listData;
            var type = this.typeOfData(dataSource).typeof;
            var searchItem = Search(this.inputElement.value, items, 'StartsWith', this.ignoreCase, dataSource, this.fields, type);
            this.searchList = false;
            if (!isNullOrUndefined(searchItem.item)) {
                _super.prototype.setAutoFill.call(this, this.liCollections[0], true);
            }
        }
    };
    AutoComplete.prototype.setSelection = function (li, e) {
        if (!this.isValidLI(li)) {
            this.selectedLI = li;
            return;
        }
        if (!isNullOrUndefined(e) && e.type === 'keydown' && e.action !== 'enter'
            && e.action !== 'tab' && this.isValidLI(li)) {
            var value = this.getFormattedValue(li.getAttribute('data-value'));
            this.activeIndex = this.getIndexByValue(value);
            this.setHoverList(li);
            this.selectedLI = li;
            this.setScrollPosition(e);
            if (this.autofill && this.isPopupOpen) {
                this.preventAutoFill = false;
                var isKeyNavigate = (e && e.action === 'down' || e.action === 'up' ||
                    e.action === 'home' || e.action === 'end' || e.action === 'pageUp' || e.action === 'pageDown');
                _super.prototype.setAutoFill.call(this, li, isKeyNavigate);
            }
        }
        else {
            _super.prototype.setSelection.call(this, li, e);
        }
    };
    AutoComplete.prototype.listOption = function (dataSource, fieldsSettings) {
        var _this_1 = this;
        var fields = _super.prototype.listOption.call(this, dataSource, fieldsSettings);
        if (isNullOrUndefined(fields.itemCreated)) {
            fields.itemCreated = function (e) {
                if (_this_1.highlight) {
                    if (_this_1.element.tagName === _this_1.getNgDirective() && _this_1.itemTemplate) {
                        setTimeout(function () {
                            highlightSearch(e.item, _this_1.queryString, _this_1.ignoreCase, _this_1.filterType);
                        }, 0);
                    }
                    else {
                        highlightSearch(e.item, _this_1.queryString, _this_1.ignoreCase, _this_1.filterType);
                    }
                }
            };
        }
        else {
            var itemCreated_1 = fields.itemCreated;
            fields.itemCreated = function (e) {
                if (_this_1.highlight) {
                    highlightSearch(e.item, _this_1.queryString, _this_1.ignoreCase, _this_1.filterType);
                }
                itemCreated_1.apply(_this_1, [e]);
            };
        }
        return fields;
    };
    AutoComplete.prototype.isFiltering = function () {
        return true;
    };
    AutoComplete.prototype.renderPopup = function (e) {
        this.list.scrollTop = 0;
        _super.prototype.renderPopup.call(this, e);
    };
    AutoComplete.prototype.isEditTextBox = function () {
        return true && this.inputElement.value.trim() !== '';
    };
    AutoComplete.prototype.isPopupButton = function () {
        return this.showPopupButton;
    };
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    AutoComplete.prototype.isSelectFocusItem = function (element) {
        return false;
    };
    AutoComplete.prototype.setInputValue = function (newProp, oldProp) {
        var oldValue = oldProp && oldProp.text ? oldProp.text : oldProp ? oldProp.value : oldProp;
        var value = newProp && newProp.text ? newProp.text : newProp && newProp.value ? newProp.value : this.value;
        if (value && this.typedString === '' && !this.allowCustom && !(this.dataSource instanceof DataManager)) {
            var checkFields_1_1 = this.typeOfData(this.dataSource).typeof === 'string' ? '' : this.fields.value;
            var listLength_1 = this.getItems().length;
            var query = new Query();
            var _this_2 = this;
            new DataManager(this.dataSource).executeQuery(query.where(new Predicate(checkFields_1_1, 'equal', value)))
                .then(function (e) {
                if (e.result.length > 0) {
                    _this_2.value = checkFields_1_1 !== '' ? e.result[0][_this_2.fields.value].toString() : e.result[0].toString();
                    _this_2.addItem(e.result, listLength_1);
                    _this_2.updateValues();
                }
                else {
                    newProp && newProp.text ? _this_2.setOldText(oldValue) : newProp && newProp.value ? _this_2.setOldValue(oldValue) : _this_2.updateValues();
                }
            });
        }
        else if (newProp) {
            newProp.text ? this.setOldText(oldValue) : this.setOldValue(oldValue);
        }
    };
    /**
     * Search the entered text and show it in the suggestion list if available.
     *
     * @returns {void}

     */
    AutoComplete.prototype.showPopup = function (e) {
        if (!this.enabled) {
            return;
        }
        if (this.beforePopupOpen) {
            this.refreshPopup();
            return;
        }
        this.beforePopupOpen = true;
        this.preventAutoFill = true;
        if (isNullOrUndefined(this.list)) {
            this.renderList(e);
        }
        else {
            this.resetList(this.dataSource, this.fields, null, e);
        }
    };
    /**
     * Hides the popup if it is in open state.
     *
     * @returns {void}
     */
    AutoComplete.prototype.hidePopup = function (e) {
        _super.prototype.hidePopup.call(this, e);
        this.activeIndex = -1;
    };
    /**
     * Dynamically change the value of properties.
     *
     * @param {AutoCompleteModel} newProp - Returns the dynamic property value of the component.
     * @param {AutoCompleteModel} oldProp - Returns the previous property value of the component.
     * @private
     * @returns {void}
     */
    AutoComplete.prototype.onPropertyChanged = function (newProp, oldProp) {
        if (this.getModuleName() === 'autocomplete') {
            this.setUpdateInitial(['fields', 'query', 'dataSource'], newProp);
        }
        for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
            var prop = _a[_i];
            switch (prop) {
                case 'showPopupButton':
                    if (this.showPopupButton) {
                        var button = Input.appendSpan(dropDownListClasses.icon, this.inputWrapper.container, this.createElement);
                        this.inputWrapper.buttons[0] = button;
                        Input.calculateWidth(this.inputElement, this.inputWrapper.container);
                        if (!isNullOrUndefined(this.inputWrapper.buttons[0]) && !isNullOrUndefined(this.inputWrapper.container.getElementsByClassName('e-float-text-overflow')[0]) && this.floatLabelType !== 'Never') {
                            this.inputWrapper.container.getElementsByClassName('e-float-text-overflow')[0].classList.add('e-icon');
                        }
                        if (this.inputWrapper && this.inputWrapper.buttons && this.inputWrapper.buttons[0]) {
                            EventHandler.add(this.inputWrapper.buttons[0], 'click', this.dropDownClick, this);
                        }
                    }
                    else {
                        detach(this.inputWrapper.buttons[0]);
                        this.inputWrapper.buttons[0] = null;
                    }
                    break;
                default: {
                    // eslint-disable-next-line max-len
                    var atcProps = this.getPropObject(prop, newProp, oldProp);
                    _super.prototype.onPropertyChanged.call(this, atcProps.newProperty, atcProps.oldProperty);
                    break;
                }
            }
        }
    };
    AutoComplete.prototype.renderHightSearch = function () {
        if (this.highlight) {
            for (var i = 0; i < this.liCollections.length; i++) {
                var isHighlight = this.ulElement.querySelector('.e-active');
                if (!isHighlight) {
                    revertHighlightSearch(this.liCollections[i]);
                    highlightSearch(this.liCollections[i], this.queryString, this.ignoreCase, this.filterType);
                }
            }
        }
    };
    /**
     * Return the module name of this component.
     *
     * @private
     * @returns {string} Return the module name of this component.
     */
    AutoComplete.prototype.getModuleName = function () {
        return 'autocomplete';
    };
    /**
     * To initialize the control rendering
     *
     * @private
     * @returns {void}
     */
    AutoComplete.prototype.render = function () {
        _super.prototype.render.call(this);
    };
    __decorate([
        Complex({ value: null, iconCss: null, groupBy: null }, FieldSettings)
    ], AutoComplete.prototype, "fields", void 0);
    __decorate([
        Property(true)
    ], AutoComplete.prototype, "ignoreCase", void 0);
    __decorate([
        Property(false)
    ], AutoComplete.prototype, "showPopupButton", void 0);
    __decorate([
        Property(false)
    ], AutoComplete.prototype, "highlight", void 0);
    __decorate([
        Property(20)
    ], AutoComplete.prototype, "suggestionCount", void 0);
    __decorate([
        Property({})
    ], AutoComplete.prototype, "htmlAttributes", void 0);
    __decorate([
        Property(null)
    ], AutoComplete.prototype, "query", void 0);
    __decorate([
        Property(1)
    ], AutoComplete.prototype, "minLength", void 0);
    __decorate([
        Property('Contains')
    ], AutoComplete.prototype, "filterType", void 0);
    __decorate([
        Event()
    ], AutoComplete.prototype, "filtering", void 0);
    __decorate([
        Property(null)
    ], AutoComplete.prototype, "index", void 0);
    __decorate([
        Property('Never')
    ], AutoComplete.prototype, "floatLabelType", void 0);
    __decorate([
        Property(null)
    ], AutoComplete.prototype, "valueTemplate", void 0);
    __decorate([
        Property(null)
    ], AutoComplete.prototype, "filterBarPlaceholder", void 0);
    __decorate([
        Property(false)
    ], AutoComplete.prototype, "allowFiltering", void 0);
    __decorate([
        Property(null)
    ], AutoComplete.prototype, "text", void 0);
    AutoComplete = __decorate([
        NotifyPropertyChanges
    ], AutoComplete);
    return AutoComplete;
}(ComboBox));
export { AutoComplete };
